/************************************************************************************/
/*  Copyright (C)           Microcyber Inc. All Rights Reserved                     */
/*  Product:                Modbus_PA Module                                        */
/*                                                                                  */
/*  Device:                 Modbus_PA Module for PROFIBUS PA                        */
/*  Description:            Device Description File                                 */
/*  Dictionary:             SIPADC01.dct                                            */
/*                                                                                  */
/*  Revision:  1.0                                                                  */
/*  Date:      2010-07-22                                                           */
/*  Author:    Wang Peng                                                            */
/************************************************************************************/
MANUFACTURER            0x16c,
DEVICE_TYPE             0x01,
DEVICE_REVISION         0x01,
DD_REVISION             0x01

#define DEVICE_NAME "M0307"
#define _MODBUS_PA

#include "SI_FileM.inc"
#include "SI_HlpM.inc"
#include "SI_OptM.inc"
#include "SIPAST_CommError.inc"

/*
#include "SI_MainMenu.inc"
#include "SI_ViewM.inc"
*/

#include "defmacros.inc"
#include "Phys_Blk.inc"
#include "modbus_tb.inc"
#include "AI4_Blk1.inc"
#include "AO4_Blk5.inc"
#include "DI4_Blk9.inc"
#include "DO4_Blk13.inc"
#include "MC_YT.inc" 



/***********************************************************************/
/*****    Menu: Specialist  **********************************************/
/***********************************************************************/

MENU Menu_Main_Specialist
{
    LABEL        [main_menu];
    ITEMS
    {
        Menu_File,
        Menu_S_Device,
        Menu_S_View,
        Menu_Options,
        Menu_Help
    }
}

/***********************************************************************/
/*****    Menu: Maintenance  *********************************************/
/***********************************************************************/

MENU Menu_Main_Maintenance
{
    LABEL        [main_menu];
    ITEMS
    {
        Menu_File,
        Menu_M_Device,
        Menu_M_View,
        Menu_Options,
        Menu_Help
    }
}

MENU upload_variables
{
    LABEL        [menu_load_to_device];
    ITEMS
    {
        /* PHYSICAL BLOCK    */
        phys_tag_desc,
        phys_descriptor,
        phys_message,
        phys_install_date,
        phys_strategy,
        phys_alert_key,

        /* TRANDSDUCER BLOCK 1: */
        trans1_generic_float_1,
        trans1_generic_float_2,
        trans1_generic_float_3,
        trans1_generic_float_4,
        trans1_generic_float_5,
        trans1_generic_float_6,
        trans1_generic_float_7,
        trans1_generic_float_8,
        trans1_generic_float_9,
        trans1_generic_float_10,
        trans1_generic_usign32_1,
        trans1_generic_usign32_2,
        trans1_generic_usign32_3,
        trans1_generic_usign32_4,
        trans1_generic_usign32_5,
        trans1_generic_usign32_6,
        trans1_generic_usign32_7,
        trans1_generic_usign32_8,
        trans1_generic_usign32_9,
        trans1_generic_usign32_10,
        trans1_generic_usign16_1,
        trans1_generic_usign16_2,
        trans1_generic_usign16_3,
        trans1_generic_usign16_4,
        trans1_generic_usign16_5,
        trans1_generic_usign16_6,
        trans1_generic_usign16_7,
        trans1_generic_usign16_8,
        trans1_generic_usign16_9,
        trans1_generic_usign16_10,
        trans1_generic_usign8_1,
        trans1_generic_usign8_2,
        trans1_generic_usign8_3,
        trans1_generic_usign8_4,
        trans1_generic_usign8_5,
        trans1_generic_usign8_6,
        trans1_generic_usign8_7,
        trans1_generic_usign8_8,
        trans1_generic_usign8_9,
        trans1_generic_usign8_10,
        trans1_generic_Octet_1,
        trans1_generic_Octet_2

        /* FUNCTION BLOCK 1: AI 1    */
        func1_AI_1_tag_desc,
        func1_AI_1_strategy,
        func1_AI_1_alert_key,
        func1_AI_1_target_mode,
        func1_AI_1_batch_id,
        func1_AI_1_batch_unit,
        func1_AI_1_batch_operation,
        func1_AI_1_batch_phase,
        func1_AI_1_channel,
        func1_AI_1_lin_type,
        func1_AI_1_pv_ftime,
        func1_AI_1_pv_upper_range_value,
        func1_AI_1_pv_lower_range_value,
        func1_AI_1_out_upper_range_value,
        func1_AI_1_out_lower_range_value,
        func1_AI_1_out_unit,
        func1_AI_1_out_decimal_point,
        func1_AI_1_alarm_hys,
        func1_AI_1_hi_hi_lim,
        func1_AI_1_hi_lim,
        func1_AI_1_lo_lim,
        func1_AI_1_lo_lo_lim,
        func1_AI_1_FSafeType,
        func1_AI_1_FSafeValue,
        func1_AI_1_out_unit_text,

        /* FUNCTION BLOCK 1: AI 2    */
        func1_AI_2_tag_desc,
        func1_AI_2_strategy,
        func1_AI_2_alert_key,
        func1_AI_2_target_mode,
        func1_AI_2_batch_id,
        func1_AI_2_batch_unit,
        func1_AI_2_batch_operation,
        func1_AI_2_batch_phase,
        func1_AI_2_channel,
        func1_AI_2_lin_type,
        func1_AI_2_pv_ftime,
        func1_AI_2_pv_upper_range_value,
        func1_AI_2_pv_lower_range_value,
        func1_AI_2_out_upper_range_value,
        func1_AI_2_out_lower_range_value,
        func1_AI_2_out_unit,
        func1_AI_2_out_decimal_point,
        func1_AI_2_alarm_hys,
        func1_AI_2_hi_hi_lim,
        func1_AI_2_hi_lim,
        func1_AI_2_lo_lim,
        func1_AI_2_lo_lo_lim,
        func1_AI_2_FSafeType,
        func1_AI_2_FSafeValue,
        func1_AI_2_out_unit_text,

        /* FUNCTION BLOCK 1: AI 3    */
        func1_AI_3_tag_desc,
        func1_AI_3_strategy,
        func1_AI_3_alert_key,
        func1_AI_3_target_mode,
        func1_AI_3_batch_id,
        func1_AI_3_batch_unit,
        func1_AI_3_batch_operation,
        func1_AI_3_batch_phase,
        func1_AI_3_channel,
        func1_AI_3_lin_type,
        func1_AI_3_pv_ftime,
        func1_AI_3_pv_upper_range_value,
        func1_AI_3_pv_lower_range_value,
        func1_AI_3_out_upper_range_value,
        func1_AI_3_out_lower_range_value,
        func1_AI_3_out_unit,
        func1_AI_3_out_decimal_point,
        func1_AI_3_alarm_hys,
        func1_AI_3_hi_hi_lim,
        func1_AI_3_hi_lim,
        func1_AI_3_lo_lim,
        func1_AI_3_lo_lo_lim,
        func1_AI_3_FSafeType,
        func1_AI_3_FSafeValue,
        func1_AI_3_out_unit_text,

        /* FUNCTION BLOCK 1: AI 4    */
        func1_AI_4_tag_desc,
        func1_AI_4_strategy,
        func1_AI_4_alert_key,
        func1_AI_4_target_mode,
        func1_AI_4_batch_id,
        func1_AI_4_batch_unit,
        func1_AI_4_batch_operation,
        func1_AI_4_batch_phase,
        func1_AI_4_channel,
        func1_AI_4_lin_type,
        func1_AI_4_pv_ftime,
        func1_AI_4_pv_upper_range_value,
        func1_AI_4_pv_lower_range_value,
        func1_AI_4_out_upper_range_value,
        func1_AI_4_out_lower_range_value,
        func1_AI_4_out_unit,
        func1_AI_4_out_decimal_point,
        func1_AI_4_alarm_hys,
        func1_AI_4_hi_hi_lim,
        func1_AI_4_hi_lim,
        func1_AI_4_lo_lim,
        func1_AI_4_lo_lo_lim,
        func1_AI_4_FSafeType,
        func1_AI_4_FSafeValue,
        func1_AI_4_out_unit_text

        /* FUNCTION BLOCK 1: AO 1    */
        func3_AO_1_tag_desc,
        func3_AO_1_strategy,
        func3_AO_1_alert_key,
        func3_AO_1_target_mode,
        func3_AO_1_batch_id,
        func3_AO_1_batch_unit,
        func3_AO_1_batch_operation,
        func3_AO_1_batch_phase,
        func3_AO_1_in_channel,
        func3_AO_1_out_channel,
        func3_AO_1_pv_upper_range_value,
        func3_AO_1_pv_lower_range_value,
        func3_AO_1_pv_unit,
        func3_AO_1_pv_decimal_point,
        func3_AO_1_out_upper_range_value,
        func3_AO_1_out_lower_range_value,
        func3_AO_1_out_unit,
        func3_AO_1_out_decimal_point,
        func3_AO_1_fsafe_type,
        func3_AO_1_fsafe_time,
        func3_AO_1_fsafe_value,
        func3_AO_1_setpoint_deviation,
        func3_AO_1_check_back,
        func3_AO_1_check_back_mask,
        func3_AO_1_increase_close,

        /* FUNCTION BLOCK 1: AO 2    */
        func3_AO_2_tag_desc,
        func3_AO_2_strategy,
        func3_AO_2_alert_key,
        func3_AO_2_target_mode,
        func3_AO_2_batch_id,
        func3_AO_2_batch_unit,
        func3_AO_2_batch_operation,
        func3_AO_2_batch_phase,
        func3_AO_2_in_channel,
        func3_AO_2_out_channel,
        func3_AO_2_pv_upper_range_value,
        func3_AO_2_pv_lower_range_value,
        func3_AO_2_pv_unit,
        func3_AO_2_pv_decimal_point,
        func3_AO_2_out_upper_range_value,
        func3_AO_2_out_lower_range_value,
        func3_AO_2_out_unit,
        func3_AO_2_out_decimal_point,
        func3_AO_2_fsafe_type,
        func3_AO_2_fsafe_time,
        func3_AO_2_fsafe_value,
        func3_AO_2_setpoint_deviation,
        func3_AO_2_check_back,
        func3_AO_2_check_back_mask,
        func3_AO_2_increase_close,

        /* FUNCTION BLOCK 1: AO 3    */
        func3_AO_3_tag_desc,
        func3_AO_3_strategy,
        func3_AO_3_alert_key,
        func3_AO_3_target_mode,
        func3_AO_3_batch_id,
        func3_AO_3_batch_unit,
        func3_AO_3_batch_operation,
        func3_AO_3_batch_phase,
        func3_AO_3_in_channel,
        func3_AO_3_out_channel,
        func3_AO_3_pv_upper_range_value,
        func3_AO_3_pv_lower_range_value,
        func3_AO_3_pv_unit,
        func3_AO_3_pv_decimal_point,
        func3_AO_3_out_upper_range_value,
        func3_AO_3_out_lower_range_value,
        func3_AO_3_out_unit,
        func3_AO_3_out_decimal_point,
        func3_AO_3_fsafe_type,
        func3_AO_3_fsafe_time,
        func3_AO_3_fsafe_value,
        func3_AO_3_setpoint_deviation,
        func3_AO_3_check_back,
        func3_AO_3_check_back_mask,
        func3_AO_3_increase_close,

        /* FUNCTION BLOCK 1: AO 4    */
        func3_AO_4_tag_desc,
        func3_AO_4_strategy,
        func3_AO_4_alert_key,
        func3_AO_4_target_mode,
        func3_AO_4_batch_id,
        func3_AO_4_batch_unit,
        func3_AO_4_batch_operation,
        func3_AO_4_batch_phase,
        func3_AO_4_in_channel,
        func3_AO_4_out_channel,
        func3_AO_4_pv_upper_range_value,
        func3_AO_4_pv_lower_range_value,
        func3_AO_4_pv_unit,
        func3_AO_4_pv_decimal_point,
        func3_AO_4_out_upper_range_value,
        func3_AO_4_out_lower_range_value,
        func3_AO_4_out_unit,
        func3_AO_4_out_decimal_point,
        func3_AO_4_fsafe_type,
        func3_AO_4_fsafe_time,
        func3_AO_4_fsafe_value,
        func3_AO_4_setpoint_deviation,
        func3_AO_4_check_back,
        func3_AO_4_check_back_mask,
        func3_AO_4_increase_close,

        /* FUNCTION BLOCK 1: DI 1    */
        func4_DI_1_tag_desc,
        func4_DI_1_strategy,
        func4_DI_1_alert_key,
        func4_DI_1_target_mode,
        func4_DI_1_batch_id,
        func4_DI_1_batch_unit,
        func4_DI_1_batch_operation,
        func4_DI_1_batch_phase,
        func4_DI_1_channel,
        func4_DI_1_invert,
        func4_DI_1_fsafe_type,
        func4_DI_1_fsafe_value,

        /* FUNCTION BLOCK 1: DI 2    */
        func4_DI_2_tag_desc,
        func4_DI_2_strategy,
        func4_DI_2_alert_key,
        func4_DI_2_target_mode,
        func4_DI_2_batch_id,
        func4_DI_2_batch_unit,
        func4_DI_2_batch_operation,
        func4_DI_2_batch_phase,
        func4_DI_2_channel,
        func4_DI_2_invert,
        func4_DI_2_fsafe_type,
        func4_DI_2_fsafe_value,

        /* FUNCTION BLOCK 1: DI 3    */
        func4_DI_3_tag_desc,
        func4_DI_3_strategy,
        func4_DI_3_alert_key,
        func4_DI_3_target_mode,
        func4_DI_3_batch_id,
        func4_DI_3_batch_unit,
        func4_DI_3_batch_operation,
        func4_DI_3_batch_phase,
        func4_DI_3_channel,
        func4_DI_3_invert,
        func4_DI_3_fsafe_type,
        func4_DI_3_fsafe_value,

        /* FUNCTION BLOCK 1: DI 4    */
        func4_DI_4_tag_desc,
        func4_DI_4_strategy,
        func4_DI_4_alert_key,
        func4_DI_4_target_mode,
        func4_DI_4_batch_id,
        func4_DI_4_batch_unit,
        func4_DI_4_batch_operation,
        func4_DI_4_batch_phase,
        func4_DI_4_channel,
        func4_DI_4_invert,
        func4_DI_4_fsafe_type,
        func4_DI_4_fsafe_value,

        /* FUNCTION BLOCK 1: DO 1    */
        func5_DO_1_tag_desc,
        func5_DO_1_strategy,
        func5_DO_1_alert_key,
        func5_DO_1_target_mode,
        func5_DO_1_batch_id,
        func5_DO_1_batch_unit,
        func5_DO_1_batch_operation,
        func5_DO_1_batch_phase,
        func5_DO_1_channel,
        func5_DO_1_invert,
        func5_DO_1_fsafe_type,
        func5_DO_1_fsafe_time,
        func5_DO_1_fsafe_value,
        func5_DO_1_check_back,
        func5_DO_1_check_back_mask,

        /* FUNCTION BLOCK 1: DO 2    */
        func5_DO_2_tag_desc,
        func5_DO_2_strategy,
        func5_DO_2_alert_key,
        func5_DO_2_target_mode,
        func5_DO_2_batch_id,
        func5_DO_2_batch_unit,
        func5_DO_2_batch_operation,
        func5_DO_2_batch_phase,
        func5_DO_2_channel,
        func5_DO_2_invert,
        func5_DO_2_fsafe_type,
        func5_DO_2_fsafe_time,
        func5_DO_2_fsafe_value,
        func5_DO_2_check_back,
        func5_DO_2_check_back_mask,

        /* FUNCTION BLOCK 1: DO 3    */
        func5_DO_3_tag_desc,
        func5_DO_3_strategy,
        func5_DO_3_alert_key,
        func5_DO_3_target_mode,
        func5_DO_3_batch_id,
        func5_DO_3_batch_unit,
        func5_DO_3_batch_operation,
        func5_DO_3_batch_phase,
        func5_DO_3_channel,
        func5_DO_3_invert,
        func5_DO_3_fsafe_type,
        func5_DO_3_fsafe_time,
        func5_DO_3_fsafe_value,
        func5_DO_3_check_back,
        func5_DO_3_check_back_mask,

        /* FUNCTION BLOCK 1: DO 4    */
        func5_DO_4_tag_desc,
        func5_DO_4_strategy,
        func5_DO_4_alert_key,
        func5_DO_4_target_mode,
        func5_DO_4_batch_id,
        func5_DO_4_batch_unit,
        func5_DO_4_batch_operation,
        func5_DO_4_batch_phase,
        func5_DO_4_channel,
        func5_DO_4_invert,
        func5_DO_4_fsafe_type,
        func5_DO_4_fsafe_time,
        func5_DO_4_fsafe_value,
        func5_DO_4_check_back,
        func5_DO_4_check_back_mask
    }
    PRE_READ_ACTIONS
    {
        method_pre_write_phys_write_locking
    }
}




/*---------------------------------------------------------------------*/
/*    Menu: Device                                                     */
/*---------------------------------------------------------------------*/

MENU Menu_S_Device
{
    LABEL        [menu_Device];
    ITEMS
    {
        std_NodeAddress,
        COLUMNBREAK,
        std_LoadinDevice,
        std_LoadinPC,
        COLUMNBREAK,
        Menu_online,
        Menu_offline,
        COLUMNBREAK,
        Menu_s_config_modbus,
        COLUMNBREAK,
        Menu_simulation,
//        OfflineWindow_LCD_display,
        COLUMNBREAK,
        OnlineDialog_reset,
        OnlineDialog_write_locking,
        OnlineDialog_ident_number
    }
}

MENU Menu_M_Device
{
    LABEL        [menu_Device];
    ITEMS
    {
        std_NodeAddress,
        COLUMNBREAK,
        std_LoadinDevice,
        std_LoadinPC,
        COLUMNBREAK,
        Menu_online,
        Menu_offline,
    }
}

MENU Menu_online
{
    LABEL [MC_Online_Conf];
    ITEMS
    {
        Menu_AI_on,
        Menu_AO_on,
        Menu_DI_on,
        Menu_DO_on
    }
}

MENU Menu_offline
{
    LABEL [MC_Offline_Conf];
    ITEMS
    {
       Menu_AI_off,
       Menu_AO_off,
       Menu_DI_off,
       Menu_DO_off
    }
}

MENU Menu_simulation
{
    LABEL        [menu_dialog_simulation];
    ITEMS
    {
        Menu_simulate_AI,
        Menu_simulate_AO,
        Menu_simulate_DI,
        Menu_simulate_DO,
    }
}

/*---------------------------------------------------------------------*/
/*    Menu: View                                                       */
/*---------------------------------------------------------------------*/
MENU Menu_S_View
{
    LABEL        [menu_View];
    ITEMS
    {
        Menu_S_display,
        COLUMNBREAK,
        //OnlineWindow_yt,
        Menu_S_alarm,
        Menu_S_diagnosis,
        COLUMNBREAK,
        std_Funktionsleiste,
        std_Statuszeile,
        COLUMNBREAK,
        std_Update     
    }
}

MENU Menu_S_display
{
    LABEL        "Display";
    ITEMS
    {
	    OnlineWindow_display_AI,
        OnlineWindow_display_AO,
	    OnlineWindow_display_DI,
        OnlineWindow_display_DO
    }
}

MENU OnlineWindow_display_AI
{
    LABEL        "Display AI";
    ITEMS
    {
	    Page_display_func1_AI_1,
        Page_display_func1_AI_2,
	    Page_display_func1_AI_3,
        Page_display_func1_AI_4
    }
}

MENU OnlineWindow_display_AO
{
    LABEL        "Display AO";
    ITEMS
    {
        Page_display_AO_1,
        Page_display_AO_2,
        Page_display_AO_3,
        Page_display_AO_4
    }
}

MENU OnlineWindow_display_DI
{
    LABEL        "Display DI";
    ITEMS
    {
        Page_display_out_func4_DI_1,
        Page_display_out_func4_DI_2,
        Page_display_out_func4_DI_3,
        Page_display_out_func4_DI_4
    }
}

MENU OnlineWindow_display_DO
{
    LABEL        "Display DO";
    ITEMS
    {
	    Page_display_measure_func5_DO_1,
        Page_display_measure_func5_DO_2,
	    Page_display_measure_func5_DO_3,
        Page_display_measure_func5_DO_4
    }
}

MENU Menu_S_alarm
{
    LABEL        [menu_dialog_alarm];
    ITEMS
    {
        OnlineWindow_S_alarm_func1_AI_1,
        OnlineWindow_S_alarm_func1_AI_2,
        OnlineWindow_S_alarm_func1_AI_3,
        OnlineWindow_S_alarm_func1_AI_4
    }
}

MENU OnlineWindow_diagnosis_AI
{
    LABEL        "Diagnosis AI";
    ITEMS
    {
        Page_diagnosis_func1_AI_1,
        Page_diagnosis_func1_AI_2,
        Page_diagnosis_func1_AI_3,
        Page_diagnosis_func1_AI_4,
    }
}
MENU OnlineWindow_diagnosis_AO
{
    LABEL        "Diagnosis AO";
    ITEMS
    {
        Page_diagnosis_func3_AO_1,
        Page_diagnosis_func3_AO_2,
        Page_diagnosis_func3_AO_3,
        Page_diagnosis_func3_AO_4
    }
}
MENU OnlineWindow_diagnosis_DI
{
    LABEL        "Diagnosis DI";
    ITEMS
    {
        Page_diagnosis_func4_DI_1,
        Page_diagnosis_func4_DI_2,
        Page_diagnosis_func4_DI_3,
        Page_diagnosis_func4_DI_4,
    }
}
MENU OnlineWindow_diagnosis_DO
{
    LABEL        "Diagnosis DO";
    ITEMS
    {
        Page_diagnosis_func5_DO_1,
        Page_diagnosis_func5_DO_2,
        Page_diagnosis_func5_DO_3,
        Page_diagnosis_func5_DO_4
    }
}

MENU Menu_S_diagnosis
{
    LABEL        "Diagnosis";
    ITEMS
    {
        Page_diagnosis_general,
        Page_diagnosis_phys_block,
        Page_diagnosis_trans1_modbus,
        OnlineWindow_diagnosis_AI,
        OnlineWindow_diagnosis_AO,
        OnlineWindow_diagnosis_DI,
        OnlineWindow_diagnosis_DO,
    }
}


/***********************************************************************/
/*****    Table: Specialist    *****************************************/
/***********************************************************************/

MENU Table_Main_Specialist
{
    LABEL    "M0307 (Specialist)";
    ITEMS
    {
        Tab_s_info,
        Tab_s_user_trd,
        Tab_s_ai,
        Tab_s_ao,
        Tab_s_di,
        Tab_s_do
    }
}

MENU Tab_s_info
{
    LABEL    [MC_Tab_info];
    ITEMS
    {
        Tab_s_manuf_info,       /* file Phys_Blk.inc */
        Tab_s_block_tag,
        Tab_s_get_info,         /* file Phys_Blk.inc */
        Tab_serial_numbers,
        Tab_device_revisions,   /* file Phys_Blk.inc */
        Tab_s_certificates      /* file Phys_Blk.inc */
    }
}

MENU Tab_s_block_tag
{
    LABEL    [MC_Tab_block_tag];
    ITEMS
    {
        phys_tag_desc,
        func1_AI_1_tag_desc,
        func1_AI_2_tag_desc,
        func1_AI_3_tag_desc,
        func1_AI_4_tag_desc,
        func3_AO_1_tag_desc,
        func3_AO_2_tag_desc,
        func3_AO_3_tag_desc,
        func3_AO_4_tag_desc,
        func4_DI_1_tag_desc,
        func4_DI_2_tag_desc,
        func4_DI_3_tag_desc,
        func4_DI_4_tag_desc,
        func5_DO_1_tag_desc,
        func5_DO_2_tag_desc,
        func5_DO_3_tag_desc,
        func5_DO_4_tag_desc
    }
}

MENU Tab_serial_numbers
{
    LABEL   [MC_Tab_serial_numbers];
    ITEMS
    {
        phys_device_ser_num   (READ_ONLY),
    }
}

MENU Tab_s_ai
{
    LABEL   "Analog Input (4)";
    ITEMS
    {
        Tab_s_AI_1,
        Tab_s_AI_2,
        Tab_s_AI_3,
        Tab_s_AI_4
    }
}

MENU Tab_s_ao
{
    LABEL   "Analog Output (4)";
    ITEMS
    {
		Tab_s_AO_1,
		Tab_s_AO_2, 
		Tab_s_AO_3,
		Tab_s_AO_4
    }
}

MENU Tab_s_di
{
    LABEL   "Discrete Input (4)";
    ITEMS
    {
		Tab_s_func4_DI_1,
		Tab_s_func4_DI_2,
		Tab_s_func4_DI_3,
		Tab_s_func4_DI_4
    }
}

MENU Tab_s_do
{
    LABEL   "Discrete Output (4)";
    ITEMS
    {
		Tab_s_func5_DO_1,
		Tab_s_func5_DO_2,
		Tab_s_func5_DO_3,
		Tab_s_func5_DO_4
    }
}

/******************************************************************************/
/*****    Table: Maintenance    ***********************************************/
/******************************************************************************/
MENU Table_Main_Maintenance
{
    LABEL    "M0307 (Maintenance)";
    ITEMS
    {
        Tab_m_info,
        Tab_m_AI,
    }
}

MENU Tab_m_info
{
    LABEL    [MC_Tab_info];
    ITEMS
    {
        Tab_m_manuf_info,       /* file Phys_Blk.inc */
        Tab_m_block_tag,
        Tab_m_get_info,         /* file Phys_Blk.inc */
        Tab_serial_numbers,     /* file Phys_Blk.inc */
        Tab_device_revisions,   /* file Phys_Blk.inc */
        Tab_m_certificates      /* file Phys_Blk.inc */
    }
}

MENU Tab_m_block_tag
{
    LABEL    [MC_Tab_block_tag];
    ITEMS
    {
        phys_tag_desc  (READ_ONLY),
        func1_AI_1_tag_desc  (READ_ONLY),
        func1_AI_2_tag_desc  (READ_ONLY),
        func1_AI_3_tag_desc  (READ_ONLY),
        func1_AI_4_tag_desc  (READ_ONLY)
    }
}

MENU Tab_m_AI
{
    LABEL   "Analog Input (4)";
    ITEMS
    {
        Tab_m_AI_1,
        Tab_m_AI_2,
        Tab_m_AI_3,
        Tab_m_AI_4
    }
}
METHOD std_NodeAddress
{
    LABEL        [menu_Device_NodeAddress];
    DEFINITION
    {
    }
}

METHOD std_LoadinDevice
{
    LABEL        [menu_Device_LoadinDevice];
    DEFINITION
    {
    }
}

METHOD std_LoadinPC
{
    LABEL        [menu_Device_LoadinPC];
    DEFINITION
    {
    }
}

METHOD std_Funktionsleiste
{
    LABEL        [menu_View_Toolbar];
    DEFINITION
    {
    }
}

METHOD std_Statuszeile
{
    LABEL        [menu_View_Statusbar];
    DEFINITION
    {
    }
}

METHOD std_Update
{
    LABEL        [menu_View_Update];
    DEFINITION
    {
    }
}

METHOD method_set
{
    LABEL        [transfer];
    HELP         [transfer_help];
    DEFINITION
    {
    }
}

METHOD  method_pre_write_phys_write_locking
{
    LABEL   [method_pre_write_phys_write_locking];
    DEFINITION
    {
        int ret;
        ReadCommand (read_phys_write_locking);
        if ( phys_write_locking == 0 )
        {
            ret = ACKNOWLEDGE([label_DeviceIsWriteProtected]);
            if (ret) process_abort();
        }
    }
}
